FUNCTION SetProc( cProcName )
/*
   ----------------------------------------------------------------
    Programmer..: Ken Mayer, Romain Strieff
    Date........: December 7, 1996
    Notes.......: Checks to see if a procedure file is open and
                  available.
    Written for.: Visual dBASE 5.5
                  Minor modifications for VdBASE 7 -- note:
                  this version will not run under earlier versions!
    Rev. History: 12/07/1996 -- Original Code
                  12/20/1996 -- Romain posted a better version
                  12/09/1997 -- Modified for VdBASE 7
                  April 30, 1999 -- updated by Gary White
                    to handle full path for a procedure
                  November, 2001 -- modification suggested
                    by Bruce Beacham to use local statement
                    for variables, to avoid problems in other
                    code.
                  February, 2002 -- modified to handle Source
                    Aliases, and after release H of the dUFLP,
                    modified so it should be usable with
                    .EXE files, which the release H version
                    wasn't, due to an oversight ...
    Calls.......: None
    Usage.......: SetProc( <cProcName> )
    Example.....: if not SetProc( "MyProcedure.PRG" )
                     set procedure to myprocedure additive
                  endif
                  // if checking for a procedure or class
                  // that uses a Source Alias:
                  if not SetProc( ":dUFLP:MathEx.cc" )
                     // etc.
                  endif
    Returns.....: Logical
    Parameters..: cProcName = Name of procedure file, needs to
                              have the extension, and if necessary,
                              (not in current directory), the path.
   ----------------------------------------------------------------
*/

   local cProcName, lRet, nProc, cCheck, cFile, cAlias, lExists, i
   // if we're in the runtime, the procedure file should
   // ignore source aliases and paths, as it should be 
   // either a DEO object or contained in the .EXE itself,
   // in either case, we shouldn't have to worry about the path
   if not "runtime" $ lower( version(1) )
      // check for Source Alias (format is 
      //                         :source alias:procedurename.ext): 
      if left( cProcName, 1 ) == ":" and ;
         at( ":", cProcName, 2 ) > 0
         // we have a Source Alias, so we have to
         // add the path to the beginning of the
         // name of the file ...
         cFile = right( cProcName, len( cProcName ) - ;
                                   rat( ":", cProcName ) )

         // get alias, and remove : from it
         cAlias = left( cProcName, at(":",cProcName,2) -1 )
         cAlias = right(cAlias,len(cAlias) -1 )
         // search the Source Alias array, but we can't just use IsKey,
         // because Source Aliases are by their nature case sensitive
         cKey = _app.SourceAliases.firstKey
         lExists = false
         for i = 1 to _app.SourceAliases.count()
             if cKey.toLowerCase() == cAlias.toLowerCase()
                lExists := true
                cProcName = _app.SourceAliases[ cKey ]+"\"+cFile
                exit
             endif
             cKey = _app.SourceAliases.nextKey( cKey )
         next
         // Problem:
         if not lExists
            msgbox( "Error, Source Alias: "+cAlias+" does not exist!",;
                    "SetProc Error", 48 )
            return
         endif
      else
         // if not a source alias, and no path given, we have
         // to assume the current folder ...
         if not "\" $ cProcname
            cProcname = set("directory") + "\" + cProcName
         endif // not "\" $ cProcName
      endif // left( cProcName, 1 ) == ":" and ...
   endif // not "runtime" $ lower( version(1) )
   lRet= false
   nProc=1
   cCheck=set("procedure",nProc)
   do while not empty( cCheck )
      if upper(cProcname)==upper(cCheck)
         lRet= true
         exit
      endif
      nProc++
      cCheck=set("procedure",nProc)
   enddo
   
RETURN lRet
// -- EoM: SetProc()

/*
   ----------------------------------------------------------------
   End of file: SetProc.prg
   ----------------------------------------------------------------
*/

