Class CertnetCGISession of CGISession from "Webclass.cc"

   ////// Method:   SorryPage //////////////////////////////////////////////
   ////// Purpose:    Returns Generic Sorry response page //////////////////
   ////// Param:      cMsg  = Error Message ////////////////////////////////
   //////             		   Accepts a char string or array of messages ///
   //////             cSubTtl Subtitle, such as 'An error has ocurred"  or /
   //////                    "data missing" ////////////////////////////////
   //////             cRecover = Suggestion for recovery ///////////////////
   //////                     such as "Press the browser's back button" ////
   //////                     or contact Web master.... ////////////////////

  /*     Revisions:  This method was changed by Staub & Associates, Inc.
                     so that the three paramaters were centered and the 
                     font size and color of font was different
 */

   Function SorryPage(cMsg,cSubTtl,cRcvr)
  
      aMsg = iif(empty(cMsg),'',cMsg)

      if type('aMsg') = 'C'   // if message is not array,
         aMsg = new array()   // convert to a one-element array
         aMsg.add(cMsg)
      endif
                               // Make private versions for type()
      cRecover =  iif(empty(cRcvr),'Press Back button and try again.',cRcvr)  
      cSubtitle = iif(empty(cSubTtl),'',cSubTtl)


      /////// Stream out header
      this.StreamHeader('Sorry!')

      with (this.fOut)

         ////// Body tag (starts body of page)  
         puts('<BODY>')
         puts('')
         puts('<P>')
         puts('<TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">')

         ////// Sorry!
         puts('	<TR>')
         puts('		<TD COLSPAN="2" BGCOLOR="#E4E4E4">')
         puts('			<H1><FONT COLOR="#999999">Sorry!</FONT>')
         puts('		</TD>')
         puts('	</TR>')

         ////// Blank Line
         puts('	<TR>')
         puts('		<TD WIDTH="9%">&nbsp;</TD>')
         puts('		<TD WIDTH="91%">&nbsp;</TD>')
         puts('	</TR>')

      ////// Subtitle

         if len(trim(cSubTitle)) > 0 // if there's a subtitle
    
            puts('	<TR>')
            puts('		<TD WIDTH="9%">&nbsp;</TD>')
            puts('		<TD WIDTH="91%"><B><CENTER><FONT SIZE="5" FACE="Arial, Helvetica">'+cSubTitle+'</FONT></B></CENTER></TD>')
            puts('	</TR>')
            puts('	<TR>')

            ////// Blank Line
            puts('		<TD WIDTH="9%">&nbsp;</TD>')
            puts('		<TD WIDTH="91%">&nbsp;</TD>')
            puts('	</TR>')

  
         endif

      ////// Traverse the message array
      	for n = 1 to aLen(aMsg,1)

            puts('	<TR>')
            puts('		<TD WIDTH="9%">&nbsp;</TD>')
            puts('		<TD WIDTH="91%"><CENTER><FONT COLOR = #FF0000><FONT SIZE="4" FACE="Arial, Helvetica">'+aMsg[n]+'</FONT></CENTER></TD>')
            puts('	</TR>')

         next

         ////// If recovery instructions exist (Contact Webmaster, Press Back
         ////// 		Button, etc.), stream it here
         if len(trim(cRecover)) > 0
            with (this.fOut)
            ////// Blank line
            puts('	<TR>')
            puts('		<TD WIDTH="9%">&nbsp;</TD>')
            puts('		<TD WIDTH="91%">&nbsp;</TD>')
            puts('	</TR>')

            ////// Recovery message
            puts('	<TR>')
            puts('		<TD WIDTH="9%">&nbsp;</TD>')
            puts('		<TD WIDTH="91%"><CENTER><FONT SIZE="3" FACE="Arial, Helvetica">'+cRecover+'</FONT></CENTER></TD>')
            puts('	</TR>')
            endwith
         endif

   
         puts('</TABLE>')
         puts('')
         puts('')
         puts('</BODY>')


      endwith

      ////// Close out HTML structure
      this.StreamFooter()
 
      quit

/*Method: IsValueThere 

Purpose: to determine if the search value entered by the user
         exists in the table and set the value of mZeroRecordsFound
         based upon the search
Param: mZeroRecordsFound - set in the calling .prg
Called by: Certnet.prg
Author: John Staub for Staub & Associates, Inc.

This code is provided free for use and may be used as such


*/

function IsValueThere(mZeroRecordsFound)

   db = new database()
   db.databasename = "CERT"
   db.active = true

   q = new query()
   q.database = db
   q.sql = [select * from afcert.dbf WHERE SSAN ="]+cSearch+["]
   q.active = true

   r = q.rowset

   if r.first()
    mZeroRecordsFound = false
   else
    mZeroRecordsFound = true 
   endif

  db.active = false
  q.active = false
  release object db
  release object q
  return mZeroRecordsFound
//end of IsValueThere



endClass
