// necessary include files
#include <Windef.h>
#include <Winbase.h>
#include <Structapi.h>

// load the Structure class
set procedure to '&_dbwinhome.samples\structure.prg' additive

// GetVersionEx function prototype as it is written in Win32api.prg
extern BOOL        GetVersionEx( LPSTRUCTURE ) kernel32 ;
                   from "GetVersionExA"


local  OSVERSIONINFO, dwPlatformId

//Creates an instance of the Structure object.
OSVERSIONINFO = new _OSVERSIONINFO( )

// Call to the GetVersionEx function, input parameter is OSVERSIONINFO.value,
// it will represent the contents of the C structure in memory.
GetVersionEx( OSVERSIONINFO.value )

// Displays the content of the structure members in the command window
? 'Major Version', OSVERSIONINFO.getMember( 'dwMajorVersion' )
? 'Minor Version', OSVERSIONINFO.getMember( 'dwMinorVersion' )
? 'Build Number', LOWORD( OSVERSIONINFO.getMember( 'dwBuildNumber' ))
dwPlatformId = OSVERSIONINFO.getMember( 'dwPlatformId' )

do case
 case dwPlatformId == VER_PLATFORM_WIN32s
  ? 'Win32s on Win 3.1'
 case dwPlatformId == VER_PLATFORM_WIN32_WINDOWS
  ? 'Win32 on Windows 95'
 case dwPlatformId == VER_PLATFORM_WIN32_NT
  ? 'Win32 on Windows NT'
endcase

// This class definition corresponds to the C structure,
// type _OSVERSIONINFO. The addMember method creates the structure members,
// using the member's type and name.
class _OSVERSIONINFO of Structure
   super::addMember( TYPE_DWORD,   "dwOSVersionInfoSize" )
   super::addMember( TYPE_DWORD,   "dwMajorVersion" )
   super::addMember( TYPE_DWORD,   "dwMinorVersion" )
   super::addMember( TYPE_DWORD,   "dwBuildNumber" )
   super::addMember( TYPE_DWORD,   "dwPlatformId" )
   super::addMember( TYPE_STRING,  "szCSDVersion", 128 )

   // The following line of code initializes the dwOSVersionInfoSize member of
   // the structure, that must, as indicated in the API 32 help file, contain the
   // structure's size.
   // The Structure class length() method returns the overall size of the structure,
   // in bytes. When an object is created using the OSVERSIONINFO class, this member
   // will be automatically initialized.
  super::setMember( "dwOSVersionInfoSize", this.length( ))
endclass


