//--------------------------------------------------------------
//
//  WINREG.H
//
//    This file contains the constant and type definitions 
//    for the Windows 32-Bit Registry API. This is a subset
//    of WINNT.H
//
//  dBASE Samples Group
//
//  $Revision:   1.3  $
//
//  Portions copyright (c) 1991-1995, Microsoft Corp. 
//
//--------------------------------------------------------------

#ifndef WINNT_H
#ifndef _WINREG_
#define _WINREG_

#include "windef.h"

//
// Requested Key access mask type.
//

#define REGSAM DWORD

//
// Type definitions.
//

#define HKEY  HANDLE
#define PHKEY PHANDLE

//
// Reserved Key Handles.
//

#define HKEY_CLASSES_ROOT           (0x80000000)
#define HKEY_CURRENT_USER           (0x80000001)
#define HKEY_LOCAL_MACHINE          (0x80000002)
#define HKEY_USERS                  (0x80000003)
#define HKEY_PERFORMANCE_DATA       (0x80000004)
#define HKEY_CURRENT_CONFIG         (0x80000005)
#define HKEY_DYN_DATA               (0x80000006)

#define PROVIDER_KEEPS_VALUE_LENGTH 0x1

#define PVALCONTEXT PSTRUCTURE

#define PVALUE STRUCTURE
#define PPVALUEA PSTRUCTURE

#define QUERYHANDLER  NEARPROC
#define PQUERYHANDLER FARPROC

#define REG_PROVIDER STRUCTURE
#define PPROVIDER    PSTRUCTURE

#define VALENT  STRUCTURE
#define PVALENT PSTRUCTURE

// From winnt.h
//
//  The following are masks for the predefined standard access types
//

// #define DELETE                           (0x00010000) // conflicts with 
//                                                       // DELETE command
#define READ_CONTROL                     (0x00020000)
#define WRITE_DAC                        (0x00040000)
#define WRITE_OWNER                      (0x00080000)
#define SYNCHRONIZE                      (0x00100000)

#define STANDARD_RIGHTS_REQUIRED         (0x000F0000)

#define STANDARD_RIGHTS_READ             (READ_CONTRO)
#define STANDARD_RIGHTS_WRITE            (READ_CONTRO)
#define STANDARD_RIGHTS_EXECUTE          (READ_CONTRO)

#define STANDARD_RIGHTS_ALL              (0x001F0000)

#define SPECIFIC_RIGHTS_ALL              (0x0000FFFF)

//
// Registry Specific Access Rights.
//

#define KEY_QUERY_VALUE         (0x0001)
#define KEY_SET_VALUE           (0x0002)
#define KEY_CREATE_SUB_KEY      (0x0004)
#define KEY_ENUMERATE_SUB_KEYS  (0x0008)
#define KEY_NOTIFY              (0x0010)
#define KEY_CREATE_LINK         (0x0020)

#define KEY_READ                (bitand(bitor(bitor(bitor(STANDARD_RIGHTS_READ, KEY_QUERY_VALUE), KEY_ENUMERATE_SUB_KEYS), KEY_NOTIFY), BITNOT( SYNCHRONIZE ) ) )
#define KEY_WRITE               (bitand(bitor(bitor(STANDARD_RIGHTS_WRITE, KEY_SET_VALUE), KEY_CREATE_SUB_KEY), BITNOT( SYNCHRONIZE) ) )
#define KEY_EXECUTE             (bitand(KEY_READ, BITNOT( SYNCHRONIZE ) ) )
#define KEY_ALL_ACCESS          (bitand(bitor(bitor(bitor(bitor(bitor(bitor(STANDARD_RIGHTS_ALL, KEY_QUERY_VALUE), KEY_SET_VALUE), KEY_CREATE_SUB_KEY), KEY_ENUMERATE_SUB_KEYS), KEY_NOTIFY), KEY_CREATE_LINK), BITNOT(SYNCHRONIZE)))

//#define KEY_READ                ((STANDARD_RIGHTS_READ | KEY_QUERY_VALUE | KEY_ENUMERATE_SUB_KEYS | KEY_NOTIFY) & (~SYNCHRONIZE))
//#define KEY_WRITE               ((STANDARD_RIGHTS_WRITE | KEY_SET_VALUE | KEY_CREATE_SUB_KEY) & (~SYNCHRONIZE))
//#define KEY_EXECUTE             ((KEY_READ) & (~SYNCHRONIZE))
//#define KEY_ALL_ACCESS          BITXOR( BITOR( BITOR( BITOR( BITOR( BITOR( BITOR( STANDARD_RIGHTS_ALL, KEY_QUERY_VALUE ), KEY_SET_VALUE ), KEY_CREATE_SUB_KEY ), KEY_ENUMERATE_SUB_KEYS ), KEY_NOTIFY ), KEY_CREATE_LINK ), SYNCHRONIZE)

//
// Open/Create Options
//

#define REG_OPTION_RESERVED         (0x00000000)   /* Parameter is reserved */
#define REG_OPTION_NON_VOLATILE     (0x00000000)   /* Key is preserved */
                                                   /* when system is rebooted */
#define REG_OPTION_VOLATILE         (0x00000001)   /* Key is not preserved */
                                                   /* when system is rebooted */
#define REG_OPTION_CREATE_LINK      (0x00000002)   /* Created key is a */
                                                   /* symbolic link */
#define REG_OPTION_BACKUP_RESTORE   (0x00000004)   /* open for backup or restore */
                                                   /* special access rules */
                                                   /* privilege required */

#define REG_LEGAL_OPTION            (bitor(bitor(bitor(bitor(REG_OPTION_RESERVED, REG_OPTION_NON_VOLATILE), REG_OPTION_VOLATILE), REG_OPTION_CREATE_LINK), REG_OPTION_BACKUP_RESTORE))

//
// Key creation/open disposition
//

#define REG_CREATED_NEW_KEY         (0x00000001)   // New Registry Key created
#define REG_OPENED_EXISTING_KEY     (0x00000002)   // Existing Key opened

//
// Predefined Value Types.
//

#define REG_NONE                    (0)   // No value type
#define REG_SZ                      (1)   // Unicode nul terminated string
#define REG_EXPAND_SZ               (2)   // Unicode nul terminated string
                                            // (with environment variable references)
#define REG_BINARY                  (3)   // Free form binary
#define REG_DWORD                   (4)   // 32-bit number
#define REG_DWORD_LITTLE_ENDIAN     (4)   // 32-bit number (same as REG_DWORD)
#define REG_DWORD_BIG_ENDIAN        (5)   // 32-bit number
#define REG_LINK                    (6)   // Symbolic Link (unicode)
#define REG_MULTI_SZ                (7)   // Multiple Unicode strings
#define REG_RESOURCE_LIST           (8)   // Resource list in the resource map
#define REG_FULL_RESOURCE_DESCRIPTOR (9)  // Resource list in the hardware description
#define REG_RESOURCE_REQUIREMENTS_LIST (10)

// From winerror.h
//
// MessageId: ERROR_SUCCESS
//
// MessageText:
//
//  The operation completed successfully.
//
#define ERROR_SUCCESS                    0

//
// MessageId: ERROR_MORE_DATA
//
// MessageText:
//
//  More data is available.
//
#define ERROR_MORE_DATA                  234 

//
// MessageId: ERROR_NO_MORE_ITEMS
//
// MessageText:
//
//  No more data is available.
//
#define ERROR_NO_MORE_ITEMS               259


#endif // _WINREG_
#endif // WINNT_H
